// Funzione per aggiungere un task
function addTask() {
    const taskInput = document.getElementById("taskInput");
    const taskText = taskInput.value.trim();

    if (taskText === "") {
        alert("Inserisci un task valido!");
        return;
    }

    const taskList = document.getElementById("taskList");

    // Crea un nuovo elemento <li>
    const li = document.createElement("li");
    li.textContent = taskText;

    // Aggiungi un pulsante per rimuovere il task
    const removeButton = document.createElement("button");
    removeButton.textContent = "Rimuovi";
    removeButton.onclick = function () {
        taskList.removeChild(li);
    };

    // Aggiungi un evento per segnare il task come completato
    li.onclick = function () {
        li.classList.toggle("completed");
    };

    // Aggiungi il pulsante di rimozione al task
    li.appendChild(removeButton);

    // Aggiungi il task alla lista
    taskList.appendChild(li);

    // Pulisci il campo di input
    taskInput.value = "";
}